clear
close all
clc
set(0,'defaultTextInterpreter','latex'); %trying to set the default
%% Data
load Spiral_static_opt.mat
load Spiral_static_orig.mat

%% Plots
n_comps = size(F_mat_orig,1);
marker_vec = {'*';'o';'x';'diamond';'square';'^'};
legend_cell = cell(1,2*n_comps);

figure
hold on
for i = 1:n_comps
plot(Omega_rpm*1e-3,F_mat_orig(i,:),'b','Marker',marker_vec{i})
plot(Omega_rpm*1e-3,F_mat_opt(i,:),'r','Marker',marker_vec{i})
legend_cell{2*i-1} = ['Original ' num2str(h_vec_orig(i)*1e6) ' $\mu m$'];
legend_cell{2*i} = ['Optimized ' num2str(h_vec_orig(i)*1e6) ' $\mu m$'];
end
xlabel('$\omega$ [krpm]')
ylabel('$W$ [$N$]')
title('Spiral Bearing original vs optimized geometry')
legend(legend_cell,'Location','northwest')
figureEditor